/*******************************************************************************
* converter.h: Threaded MPEG converters
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: converter.h,v 1.1 2001/10/06 21:23:36 bozo Exp $
*
* Authors: Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _MPEG_CONVERTER_H_
#define _MPEG_CONVERTER_H_


//------------------------------------------------------------------------------
// C_MpegConverter class
//------------------------------------------------------------------------------
// Base class for converters
//------------------------------------------------------------------------------
class C_MpegConverter : public C_Thread
{
public:
  C_MpegConverter(handle hLog, C_Broadcast* pBroadcast,
                  C_MpegReader* pReader,
                  C_NetList* pTsProvider, C_SyncFifo* pBuffer,
                  C_EventHandler* pEventHandler);
  ~C_MpegConverter();
  void Resume();
  void Suspend();
  void ShortPause();

protected:
  virtual void InitWork();
  virtual void StopWork();
  virtual void CleanWork() { };

  handle m_hLog;

  C_Broadcast*  m_pBroadcast;
  C_MpegReader* m_pReader;
  C_NetList*    m_pTsProvider;
  C_SyncFifo*   m_pBuffer;

  C_EventHandler* m_pEventHandler;

  int m_iLongPauseStatus;
  int m_iShortPauseStatus;

  C_Condition m_cResumeCond;

  bool m_bStop;
};


//------------------------------------------------------------------------------
// C_Ts2TsConverter class
//------------------------------------------------------------------------------
// Mpeg 2 TS -> Mpeg 2 TS (no conversion)
//------------------------------------------------------------------------------
class C_Ts2TsConverter : public C_MpegConverter
{
public:
  C_Ts2TsConverter(handle hLog, C_Broadcast* pBroadcast,
                   C_MpegReader* pReader,
                   C_NetList* pTsProvider, C_SyncFifo* pBuffer,
                   C_EventHandler* pEventHandler);

protected:
  virtual void InitWork();
  virtual void DoWork();

  int FillPacket(C_TsPacket* pPacket);
  int SyncFillPacket(C_TsPacket* pPacket);
};


//------------------------------------------------------------------------------
// C_Ps2TsConverter class
//------------------------------------------------------------------------------
// Mpeg 1/2 PS -> Mpeg 2 TS (Mpeg 1 not yet supported)
//------------------------------------------------------------------------------
class C_Ps2TsConverter : public C_MpegConverter
{
public:
  C_Ps2TsConverter(handle hLog, C_Broadcast* pBroadcast,
                   C_MpegReader* pReader,
                   C_NetList* pTsProvider, C_SyncFifo* pBuffer,
                   C_EventHandler* pEventHandler,
                   unsigned int iMpegVersion, bool bPreParse);

  C_ProgramDescriptor* GetPgrmDescriptor();

protected:
  virtual void InitWork();
  virtual void DoWork();

private:
  C_Ps2Ts<C_MpegReader, C_NetList> m_cConverter;

  bool m_bPreParse;
};


#else
#error "Multiple inclusions of converter.h"
#endif

